/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.table3.LabelLayoutWrapper;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.LabelLayoutCellRenderer;

public class LabelLayoutEditor
extends SeriesEditor
implements ActionListener,
ItemListener,
FocusListener {
    private TextField textHoriz;
    private TextField textVert;
    private Choice choiceColumn;
    private Choice choiceRow;

    public LabelLayoutEditor() {
        super(0);
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new LabelLayoutWrapper(0, 0, 0, 0);
        }
        this.tableView.setLabelLayout((LabelLayoutWrapper)object);
        this.updatePropertyPanel();
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getLabelLayout();
    }

    public String getJavaInitializationString() {
        return "new jclass.table3.LabelLayoutWrapper(" + this.getAsText() + ")";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.textHoriz) || object.equals(this.textVert)) {
            this.setOffset();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        Object object = focusEvent.getSource();
        if (object.equals(this.textHoriz) || object.equals(this.textVert)) {
            this.setOffset();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceColumn) || object.equals(this.choiceRow)) {
            String string = this.choiceColumn.getSelectedItem();
            String string2 = this.choiceRow.getSelectedItem();
            this.tableView.setRowLabelPlacement(string2.equals("left") ? 0 : 2);
            this.tableView.setColumnLabelPlacement(string.equals("top") ? 0 : 6);
            this.support.firePropertyChange("labelLayout", null, this.getValue());
        }
    }

    protected void init() {
        super.init();
        this.tableView.setSelectionPolicy(0);
    }

    protected void updatePropertyPanel() {
        ((TextComponent)this.textVert).setText(String.valueOf(this.tableView.getColumnLabelOffset()));
        ((TextComponent)this.textHoriz).setText(String.valueOf(this.tableView.getRowLabelOffset()));
        this.choiceRow.select(this.tableView.getRowLabelPlacement() == 0 ? "left" : "right");
        this.choiceColumn.select(this.tableView.getColumnLabelPlacement() == 0 ? "top" : "bottom");
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new LabelLayoutCellRenderer(this);
    }

    protected Component makePropertyPanel() {
        this.textHoriz = new TextField("0", 2);
        this.textVert = new TextField("0", 2);
        GroupPanel groupPanel = new GroupPanel("Label Offset");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new Label("Row"), gridBagConstraints);
        groupPanel.add((Component)this.textHoriz, gridBagConstraints);
        groupPanel.add((Component)new Label("pixels  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Column"), gridBagConstraints);
        groupPanel.add((Component)this.textVert, gridBagConstraints);
        groupPanel.add((Component)new Label("pixels  "), gridBagConstraints);
        this.choiceColumn = new Choice();
        this.choiceColumn.addItem("top");
        this.choiceColumn.addItem("bottom");
        this.choiceRow = new Choice();
        this.choiceRow.addItem("left");
        this.choiceRow.addItem("right");
        GroupPanel groupPanel2 = new GroupPanel("Label Placement");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel2.add((Component)new Label("Row"), gridBagConstraints);
        groupPanel2.add((Component)this.choiceRow, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel2.add((Component)new Label("Column"), gridBagConstraints);
        groupPanel2.add((Component)this.choiceColumn, gridBagConstraints);
        Panel panel = new Panel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(6);
        panel.setLayout(borderLayout);
        panel.add("West", groupPanel);
        panel.add("Center", groupPanel2);
        this.choiceRow.addItemListener(this);
        this.choiceColumn.addItemListener(this);
        this.textHoriz.addActionListener(this);
        this.textVert.addActionListener(this);
        this.textHoriz.addFocusListener(this);
        this.textVert.addFocusListener(this);
        return panel;
    }

    private void setOffset() {
        this.tableView.setRowLabelOffset(this.getInt(this.textHoriz.getText()));
        this.tableView.setColumnLabelOffset(this.getInt(this.textVert.getText()));
        this.support.firePropertyChange("labelLayout", null, this.getValue());
    }

    private int getInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }
}

